/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionEntry;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.q_misc_util.Helper;

public class PortalCollisionHandler {
    private static final int maxCollidingPortals = 6;
    public long lastActiveTime;
    public final List<PortalCollisionEntry> portalCollisions = new ArrayList<PortalCollisionEntry>();

    public boolean isRecentlyCollidingWithPortal(Entity entity) {
        return (long)PortalCollisionHandler.getTiming(entity) - this.lastActiveTime < 20L;
    }

    public void update(Entity entity) {
        this.portalCollisions.removeIf(p -> {
            if (p.portal.m_9236_() != entity.m_9236_()) {
                return true;
            }
            AABB stretchedBoundingBox = CollisionHelper.getStretchedBoundingBox(entity);
            if (!stretchedBoundingBox.m_82400_(0.5).m_82381_(p.portal.m_20191_())) {
                return true;
            }
            if (Math.abs((long)PortalCollisionHandler.getTiming(entity) - p.activeTime) >= 3L) {
                return true;
            }
            return !CollisionHelper.canCollideWithPortal(entity, p.portal, 0.0f);
        });
    }

    private static int getTiming(Entity entity) {
        return entity.f_19797_;
    }

    public Vec3 handleCollision(Entity entity, Vec3 attemptedMove) {
        if (this.portalCollisions.isEmpty()) {
            return attemptedMove;
        }
        entity.m_9236_().m_46473_().m_6180_("cross_portal_collision");
        this.portalCollisions.sort(Comparator.comparingLong(p -> p.activeTime).reversed());
        Vec3 result = PortalCollisionHandler.doHandleCollision(entity, attemptedMove, 1, this.portalCollisions, entity.m_20191_());
        entity.m_9236_().m_46473_().m_7238_();
        return result;
    }

    private static Vec3 doHandleCollision(Entity entity, Vec3 attemptedMove, int portalLayer, List<PortalCollisionEntry> portalCollisions, AABB originalBoundingBox) {
        Vec3 currentMove = attemptedMove;
        currentMove = PortalCollisionHandler.handleThisSideMove(entity, currentMove, originalBoundingBox, portalCollisions);
        for (PortalCollisionEntry portalCollision : portalCollisions) {
            currentMove = PortalCollisionHandler.handleOtherSideMove(entity, currentMove, portalCollision.portal, originalBoundingBox, portalLayer);
        }
        return new Vec3(CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.f_82479_, currentMove.f_82479_), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.f_82480_, currentMove.f_82480_), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.f_82481_, currentMove.f_82481_));
    }

    private static Vec3 handleOtherSideMove(Entity entity, Vec3 attemptedMove, Portal collidingPortal, AABB originalBoundingBox, int portalLayer) {
        if (!collidingPortal.getHasCrossPortalCollision()) {
            return attemptedMove;
        }
        if (portalLayer >= 5) {
            return attemptedMove;
        }
        Vec3 transformedAttemptedMove = collidingPortal.transformLocalVec(attemptedMove);
        AABB boxOtherSide = CollisionHelper.transformBox(collidingPortal, originalBoundingBox);
        if (boxOtherSide == null) {
            return attemptedMove;
        }
        Level destinationWorld = collidingPortal.getDestWorld();
        if (!destinationWorld.m_46805_(BlockPos.m_274446_((Position)boxOtherSide.m_82399_()))) {
            return PortalCollisionHandler.handleOtherSideChunkNotLoaded(entity, attemptedMove, collidingPortal, originalBoundingBox);
        }
        List<Portal> indirectCollidingPortals = McHelper.findEntitiesByBox(Portal.class, collidingPortal.getDestinationWorld(), boxOtherSide.m_82369_(transformedAttemptedMove), IPGlobal.maxNormalPortalRadius, p -> CollisionHelper.canCollideWithPortal(entity, p, 0.0f) && collidingPortal.isOnDestinationSide(p.getOriginPos(), 0.1));
        PortalLike collisionHandlingUnit = CollisionHelper.getCollisionHandlingUnit(collidingPortal);
        Direction transformedGravityDirection = collidingPortal.getTransformedGravityDirection(GravityChangerInterface.invoker.getGravityDirection(entity));
        Vec3 collided = transformedAttemptedMove;
        collided = CollisionHelper.handleCollisionWithShapeProcessor(entity, boxOtherSide, destinationWorld, collided, shape -> {
            VoxelShape current = CollisionHelper.clipVoxelShape(shape, collidingPortal.getDestPos(), collidingPortal.getContentDirection());
            if (current == null) {
                return null;
            }
            if (!indirectCollidingPortals.isEmpty()) {
                current = PortalCollisionHandler.processThisSideCollisionShape(current, indirectCollidingPortals);
            }
            return current;
        }, transformedGravityDirection, collidingPortal.getScale());
        if (!indirectCollidingPortals.isEmpty()) {
            for (Portal indirectCollidingPortal : indirectCollidingPortals) {
                collided = PortalCollisionHandler.handleOtherSideMove(entity, collided, indirectCollidingPortal, boxOtherSide, portalLayer + 1);
            }
        }
        collided = new Vec3(CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.f_82479_, collided.f_82479_), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.f_82480_, collided.f_82480_), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.f_82481_, collided.f_82481_));
        Vec3 result = collidingPortal.inverseTransformLocalVec(collided);
        return result;
    }

    private static Vec3 handleOtherSideChunkNotLoaded(Entity entity, Vec3 attemptedMove, Portal collidingPortal, AABB originalBoundingBox) {
        Vec3 innerDirection;
        if (entity instanceof Player && entity.m_9236_().m_5776_()) {
            CollisionHelper.informClientStagnant();
        }
        if (attemptedMove.m_82526_(innerDirection = collidingPortal.getNormal().m_82490_(-1.0)) < 0.0) {
            return attemptedMove;
        }
        double innerSignedDistance = Arrays.stream(Helper.eightVerticesOf(originalBoundingBox)).mapToDouble(pos -> pos.m_82546_(collidingPortal.getOriginPos()).m_82526_(collidingPortal.getNormal())).min().orElseThrow();
        if (innerSignedDistance < 0.0) {
            return attemptedMove.m_82549_(collidingPortal.getNormal().m_82490_(-innerSignedDistance)).m_82546_(innerDirection.m_82490_(innerDirection.m_82526_(attemptedMove)));
        }
        return attemptedMove.m_82546_(innerDirection.m_82490_(innerDirection.m_82526_(attemptedMove)));
    }

    private static Vec3 handleThisSideMove(Entity entity, Vec3 attemptedMove, AABB originalBoundingBox, List<PortalCollisionEntry> portalCollisions) {
        Direction gravity = GravityChangerInterface.invoker.getGravityDirection(entity);
        return CollisionHelper.handleCollisionWithShapeProcessor(entity, entity.m_20191_(), entity.m_9236_(), attemptedMove, shape -> PortalCollisionHandler.processThisSideCollisionShape(shape, Helper.mappedListView(portalCollisions, e -> e.portal)), gravity, 1.0);
    }

    @Nullable
    private static VoxelShape processThisSideCollisionShape(VoxelShape originalShape, List<Portal> portalCollisions) {
        VoxelShape shape = originalShape;
        if (shape.m_83281_()) {
            return shape;
        }
        AABB shapeBounds = shape.m_83215_();
        for (int i = 0; i < portalCollisions.size(); ++i) {
            Portal portal = portalCollisions.get(i);
            boolean boxFullyBehindPlane = CollisionHelper.isBoxFullyBehindPlane(portal.getOriginPos(), portal.getNormal(), shapeBounds);
            if (!boxFullyBehindPlane) continue;
            VoxelShape exclusion = portal.getThisSideCollisionExclusion();
            if (Helper.boxContains(exclusion.m_83215_(), shapeBounds)) {
                return null;
            }
            if ((shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)exclusion, (BooleanOp)BooleanOp.f_82685_)).m_83281_()) {
                return shape;
            }
            shapeBounds = shape.m_83215_();
        }
        return shape;
    }

    @Nullable
    public AABB getActiveCollisionBox(Entity entity, AABB rawBoundingBox) {
        AABB currentBox = rawBoundingBox;
        for (PortalCollisionEntry portalCollision : this.portalCollisions) {
            Portal portal = portalCollision.portal;
            AABB newBox = CollisionHelper.clipBox(currentBox, portal.getOriginPos(), portal.getNormal());
            if (newBox == null) {
                return null;
            }
            currentBox = newBox;
        }
        return currentBox;
    }

    public static void updateCollidingPortalAfterTeleportation(Entity entity, Vec3 newEyePos, Vec3 newLastTickEyePos, float partialTicks) {
        ((IEEntity)entity).ip_clearCollidingPortal();
        McHelper.findEntitiesByBox(Portal.class, entity.m_9236_(), CollisionHelper.getStretchedBoundingBox(entity), IPGlobal.maxNormalPortalRadius, p -> true).forEach(p -> CollisionHelper.notifyCollidingPortals(p, partialTicks));
        McHelper.setEyePos(entity, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox(entity);
    }

    public boolean hasCollisionEntry() {
        return !this.portalCollisions.isEmpty();
    }

    public void notifyCollidingWithPortal(Entity entity, Portal portal) {
        if (this.portalCollisions.size() >= 6) {
            return;
        }
        long timing = PortalCollisionHandler.getTiming(entity);
        int i = Helper.indexOf(this.portalCollisions, p -> p.portal == portal);
        if (i == -1) {
            this.portalCollisions.add(new PortalCollisionEntry(portal, timing));
        } else {
            this.portalCollisions.get((int)i).activeTime = timing;
        }
        portal.onCollidingWithEntity(entity);
        this.lastActiveTime = timing;
    }

    public List<Portal> getCollidingPortals() {
        return Helper.mappedListView(this.portalCollisions, p -> p.portal);
    }
}

